<?php
session_start();

$host   = "webdev.iyaserver.com";
$userid = "dhreid_guest";
$userpw = "tPTG;A+J{]Ze";
$db     = "dhreid_marketplace";

$mysql = new mysqli($host, $userid, $userpw, $db);
if ($mysql->connect_errno) {
    die("DB connection error: " . $mysql->connect_error);
}

$signup_success = $_SESSION['signup_success'] ?? "";
unset($_SESSION['signup_success']);

$error = "";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $email = trim($_POST['email'] ?? "");
    $password = trim($_POST['password'] ?? "");

    if ($email === "" || $password === "") {
        $error = "Please enter both email and password.";
    } else {

        $stmt = $mysql->prepare(
                "SELECT user_id, full_name, password, is_admin
FROM users
WHERE usc_email = ?
LIMIT 1"
        );
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $result = $stmt->get_result();
        $user = $result->fetch_assoc();

        if (!$user) {
            $error = "Account not found.";
        } else {
            $stored = $user['password'];

            if ($stored !== $password) {
                $error = "Incorrect password.";
            } else {
                $_SESSION['user_id']   = $user['user_id'];
                $_SESSION['full_name'] = $user['full_name'];
                $_SESSION['is_admin']  = $user['is_admin'];
                $_SESSION['usc_email']     = $email;

                header("Location: LandingPage.php");
                exit();
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-FEM3Q0G7NZ"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', 'G-FEM3Q0G7NZ');
    </script>
    <meta charset="UTF-8" />
    <title>USC Marketplace Login</title>

    <!-- CSS FILE -->
    <link rel="stylesheet" href="stylesheet.css">

    <!-- FONT -->
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;700&display=swap" rel="stylesheet">

    <style>
        body {
            margin: 0;
            font-family: "Montserrat", system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: #ffffff;
            display:flex;
            align-items:center;
            justify-content:center;
            background-image:
                    linear-gradient(to right, rgba(153,0,0,0.05) 1px, transparent 1px),
                    linear-gradient(to bottom, rgba(153,0,0,0.05) 1px, transparent 1px);
            background-size: 40px 40px;
        }

        #topBanner {
            display: flex;
            align-items: center;
            justify-content: center;
            width: 90%;
            height: fit-content;
            margin: 30px;
            border-radius: 10px;
            position: relative;
        }

        .back-button {
            position: absolute;
            left: 0;
            top: 50%;
            transform: translateY(-50%);
            background: #990000;
            color: white;
            border: none;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            font-size: 24px;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(153, 0, 0, 0.3);
        }

        .back-button:hover {
            background: #7a0000;
            transform: translateY(-50%) scale(1.1);
            box-shadow: 0 6px 20px rgba(153, 0, 0, 0.4);
        }

        .main-title {
            font-size: 3em;
            font-weight: 700;
            text-align: center;
            color: #990000;
            letter-spacing: 2px;
        }

        .page-wrapper {
            width:80%;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px 20px;
        }

        .pageWrapper {
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            position:fixed center;

        }

        .login-card {
            display: flex;
            width: 950px;
            height: fit-content;
            border-radius: 32px;
            overflow: hidden;
            background-color: #990000;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
            margin-bottom: 50px;
        }

        .login-left {
            flex: 2;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 40px;
            height: fit-content;
        }

        .login-panel {
            width: 90%;
            display: flex;
            align-items: center;
            justify-content: center;
            max-width: 700px;
            background: white;
            border-radius: 26px;
            padding: 50px;
            height: 90%;
            margin: 30px;
            flex-direction: column;
            text-align: left;
        }

        .login-title {
            text-align: center;
            margin: 0 0 40px;
            font-size: 26px;
            letter-spacing: 2px;
            color: #990000;
        }

        .login-form {
            display: flex;
            flex-direction: column;
            gap: 18px;
        }

        .login-form label {
            font-size: 14px;
            font-weight: 600;
            color: #990000;
        }

        .login-form input {
            margin-top: 4px;
            width: 350px;
            padding: 10px 14px;
            border-radius: 18px;
            border: 2px solid #990000;
            font-size: 14px;
            outline: none;
        }

        .login-form input:focus {
            box-shadow: 0 0 0 2px rgba(127, 35, 27, 0.2);
        }

        .btn-signin {
            align-self: center;
            margin-top: 24px;
            padding: 10px 36px;
            border-radius: 18px;
            border: none;
            background-color: #990000;
            color: white;
            font-weight: 600;
            font-size: 14px;
            cursor: pointer;
        }

        .btn-signin:hover {
            filter: brightness(0.9);
        }

        .create-link {
            margin-top: 14px;
            font-size: 14px;
            color: #990000;
            text-decoration: none;
        }

        .error-box {
            color:#b91c1c;
            font-size:14px;
            margin-bottom:12px;
            text-align:center;
        }

        .success-box {
            color:#166534;
            font-size:14px;
            margin-bottom:12px;
            text-align:center;
        }

        .login-right {
            width:400px;
            height:auto;
            background: #FFC72C;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .peace-img {
            max-width: 90%;
            height: auto;
            transition: transform 0.3s ease, filter 0.3s ease;
        }

        .peace-img:hover {
            transform: scale(1.08);
            filter: brightness(1.15);
        }

        .peace-img {
            cursor: pointer;
            transition: transform 0.4s ease;
            transform-origin: center;
        }

        .peace-img.animate {
            transform: rotate(20deg) scale(1.25);
        }

        @media (max-width: 800px) {
            .login-card {
                flex-direction: column;
                height: auto;
            }

            .login-right {
                padding: 30px 0;
            }

            .login-panel {
                padding: 40px 40px 30px;
            }

            .back-button {
                width: 45px;
                height: 45px;
                font-size: 20px;
            }
        }
    </style>
</head>

<body>

<div class="page-wrapper">
    <div class="pageWrapper">

        <!-- Banner with Back Button -->
        <div id="topBanner">
            <button class="back-button" onclick="window.location.href='LandingPage.php'" title="Back to Marketplace">
                ←
            </button>
            <h1 class="main-title">USC Student Marketplace</h1>
        </div>

        <!-- Login Card -->
        <div class="login-card">

            <div class="login-left">
                <div class="login-panel">
                    <h1 class="login-title">LOGIN</h1>

                    <?php if ($error !== ""): ?>
                        <div class="error-box"><?php echo htmlspecialchars($error); ?></div>
                    <?php endif; ?>

                    <?php if (!empty($signup_success)): ?>
                        <div class="success-box"><?php echo htmlspecialchars($signup_success); ?></div>
                    <?php endif; ?>

                    <form class="login-form" method="POST">
                        <label for="email">USC Email</label>
                        <input type="email" name="email" id="email" placeholder="name@usc.edu" required />

                        <label for="password">Password</label>
                        <input type="password" name="password" id="password" required />

                        <button type="submit" class="btn-signin">SIGN IN</button>
                    </form>

                    <a href="sign_upPage.php" class="create-link">Create New Account</a>
                </div>
            </div>

            <div class="login-right">
                <img src="fightOn.png" alt="Fight On hand sign" class="peace-img" id="fightOnImg">
            </div>

        </div>
    </div>
</div>
<script>
    const fightOn = document.getElementById("fightOnImg");

    fightOn.addEventListener("click", () => {
        fightOn.classList.add("animate");
        setTimeout(() => {
            fightOn.classList.remove("animate");
        }, 400);
    });
</script>

</body>
</html>