<?php
session_start();
// === DB connection ===
$host   = "webdev.iyaserver.com";
$userid = "dhreid_guest";
$userpw = "tPTG;A+J{]Ze";
$db     = "dhreid_marketplace";

$mysql = new mysqli($host, $userid, $userpw, $db);
if($mysql->connect_errno){
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'DB connection error']);
    exit();
}

// === Validate input ===
$item_id = isset($_GET['item_id']) ? intval($_GET['item_id']) : 0;
if ($item_id <= 0) {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => 'Invalid item_id']);
    exit();
}

// === Fetch item from DB ===
// Adjust table/column names if yours differ
$stmt = $mysql->prepare("SELECT item_id, title, description FROM items WHERE item_id = ?");
if (!$stmt) {
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'error' => $mysql->error]);
    exit();
}

$stmt->bind_param("i", $item_id);
$stmt->execute();
$res = $stmt->get_result();
$row = $res->fetch_assoc();
$stmt->close();

header('Content-Type: application/json');

if (!$row) {
    echo json_encode(['ok' => false, 'error' => 'Item not found']);
    exit();
}

// === Return JSON ===
echo json_encode([
    'ok'          => true,
    'item_id'     => $row['item_id'],
    'title'       => $row['title'],
    'description' => $row['description']
]);
exit();
?>